/**
*     Copyright (c) 2023, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file main.c
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2023, Nations Technologies Inc. All rights reserved.
**/

#include "main.h"

TIM_TimeBaseInitType TIM_TimeBaseStructure;
OCInitType TIM_OCInitStructure;
TIM_BDTRInitType TIM_BDTRInitStructure;

/**
*\*\name    main.
*\*\fun     main program.
*\*\param   none
*\*\return  none 
**/
int main(void)
{
    /* System Clocks Configuration */
    RCC_Configuration();

    /* NVIC Configuration */
    NVIC_Configuration();

    /* GPIO Configuration */
    GPIO_Configuration();

    /* SysTick Configuration */
    SysTick_Configuration();

    /*
    The TIMx peripheral offers the possibility to program in advance the
    configuration for the next TIMx outputs behaviour (step) and change the configuration
    of all the channels at the same time. This operation is possible when the COM
    (commutation) event is used.
    The COM event can be generated by software by setting the COM bit in the TIMx_EVTGEN
    register or by hardware (on TRC rising edge).
    In this example, a software COM event is generated each 100 ms: using the Systick
    interrupt.
    The TIMx is configured in Timing Mode, each time a COM event occurs,
    a new TIMx configuration will be set in advance.
    The following Table  describes the TIMx Channels states:
              -----------------------------------------------
             | Step1 | Step2 | Step3 | Step4 | Step5 | Step6 |
    ----------------------------------------------------------
    |Channel1  |   1   |   0   |   0   |   0   |   0   |   1   |
    ----------------------------------------------------------
    |Channel1N |   0   |   0   |   1   |   1   |   0   |   0   |
    ----------------------------------------------------------
    |Channel2  |   0   |   0   |   0   |   1   |   1   |   0   |
    ----------------------------------------------------------
    |Channel2N |   1   |   1   |   0   |   0   |   0   |   0   |
    ----------------------------------------------------------
    |Channel3  |   0   |   1   |   1   |   0   |   0   |   0   |
    ----------------------------------------------------------
    |Channel3N |   0   |   0   |   0   |   0   |   1   |   1   |
    ----------------------------------------------------------    
    */  

    /* Time Base configuration */
    TIM_InitTimBaseStruct(&TIM_TimeBaseStructure);    
    TIM_TimeBaseStructure.Prescaler     = 0;
    TIM_TimeBaseStructure.CounterMode   = TIM_CNT_MODE_UP;
    TIM_TimeBaseStructure.Period        = 4095;
    TIM_TimeBaseStructure.ClkDiv        = TIM_CLK_DIV1;
    TIM_TimeBaseStructure.RepetCnt      = 0;
    TIM_InitTimeBase(TIMx, &TIM_TimeBaseStructure);   

     /* Channel 1, 2 and 3 Configuration in PWM mode */
    TIM_InitOcStruct(&TIM_OCInitStructure);     
    TIM_OCInitStructure.OCMode       = TIM_OCMODE_TIMING;
    TIM_OCInitStructure.OutputState  = TIM_OUTPUT_STATE_ENABLE;
    TIM_OCInitStructure.OutputNState = TIM_OUTPUT_NSTATE_ENABLE;
    TIM_OCInitStructure.Pulse        = 2047;
    TIM_OCInitStructure.OCPolarity   = TIM_OC_POLARITY_HIGH;
    TIM_OCInitStructure.OCNPolarity  = TIM_OCN_POLARITY_HIGH;
    TIM_OCInitStructure.OCIdleState  = TIM_OC_IDLE_STATE_SET;
    TIM_OCInitStructure.OCNIdleState = TIM_OCN_IDLE_STATE_SET;
    TIM_InitOc1(TIMx, &TIM_OCInitStructure);   
    
    TIM_OCInitStructure.Pulse = 1023;
    TIM_InitOc2(TIMx, &TIM_OCInitStructure);

    TIM_OCInitStructure.Pulse = 511;
    TIM_InitOc3(TIMx, &TIM_OCInitStructure);

    /* Automatic Output enable, Break, dead time and lock configuration*/
    TIM_InitBkdtStruct(&TIM_BDTRInitStructure);
    TIM_BDTRInitStructure.OSSRState       = TIM_OSSR_STATE_ENABLE;
    TIM_BDTRInitStructure.OSSIState       = TIM_OSSI_STATE_ENABLE;
    TIM_BDTRInitStructure.LOCKLevel       = TIM_LOCK_LEVEL_OFF;
    TIM_BDTRInitStructure.DeadTime        = 1;
    TIM_BDTRInitStructure.Break           = TIM_BREAK_IN_DISABLE; 
    TIM_BDTRInitStructure.AutomaticOutput = TIM_AUTO_OUTPUT_ENABLE;

    TIM_ConfigBkdt(TIMx, &TIM_BDTRInitStructure);
    
    TIM_EnableCapCmpPreloadControl(TIMx, ENABLE);

    /* interrupt Enable */
    TIM_ConfigInt(TIMx, TIM_INT_COM, ENABLE);   
    
    /* TIM1 counter enable */
    TIM_Enable(TIMx, ENABLE);    
    
    /* Main Output Enable */
    TIM_EnableCtrlPwmOutputs(TIMx, ENABLE);    
    
    while (1);

}

/**
*\*\name    RCC_Configuration.
*\*\fun     Configures the different system clocks.
*\*\param   none
*\*\return  none 
**/
void RCC_Configuration(void)
{
    /* TIMx, GPIOx and AFIO clocks enable */
    RCC_EnableAHBPeriphClk(TIMx_CLK,ENABLE);
    RCC_EnableAHB1PeriphClk(TIMx_CH1_GPIO_CLK | TIMx_CH2_GPIO_CLK |\
                            TIMx_CH3_GPIO_CLK | TIMx_CH1N_GPIO_CLK |\
                            TIMx_CH2N_GPIO_CLK | TIMx_CH3N_GPIO_CLK,ENABLE);
    RCC_EnableAPB2PeriphClk(RCC_APB2_PERIPH_AFIO,ENABLE);
}

/**
*\*\name    NVIC_Configuration.
*\*\fun     Configures the nested vectored interrupt controller.
*\*\param   none
*\*\return  none 
**/
void NVIC_Configuration(void)
{
    NVIC_InitType NVIC_InitStructure;

    /* Enable the TIMx Interrupt */
    NVIC_InitStructure.NVIC_IRQChannel                   = TIMx_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority        = 1;    
    NVIC_InitStructure.NVIC_IRQChannelCmd                = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
}

/**
*\*\name    GPIO_Configuration.
*\*\fun     Configures the GPIO pins.
*\*\param   none
*\*\return  none 
**/
void GPIO_Configuration(void)
{
    GPIO_InitType GPIO_InitStructure;

    GPIO_InitStruct(&GPIO_InitStructure);
    /* GPIOx Configuration: Pin of TIMx */
    GPIO_InitStructure.Pin        = TIMx_CH1_GPIO_PIN;
    GPIO_InitStructure.GPIO_Mode  = GPIO_MODE_AF_PP;
    GPIO_InitStructure.GPIO_Slew_Rate = GPIO_SLEW_RATE_SLOW;
    GPIO_InitStructure.GPIO_Alternate = TIMx_CH1_GPIO_AF;
    GPIO_InitPeripheral(TIMx_CH1_GPIO_PORT, &GPIO_InitStructure);
    
    GPIO_InitStructure.Pin        = TIMx_CH2_GPIO_PIN;
    GPIO_InitStructure.GPIO_Alternate = TIMx_CH2_GPIO_AF;
    GPIO_InitPeripheral(TIMx_CH2_GPIO_PORT, &GPIO_InitStructure);   

    GPIO_InitStructure.Pin        = TIMx_CH3_GPIO_PIN;
    GPIO_InitStructure.GPIO_Alternate = TIMx_CH3_GPIO_AF;
    GPIO_InitPeripheral(TIMx_CH3_GPIO_PORT, &GPIO_InitStructure);   

    GPIO_InitStructure.Pin        = TIMx_CH1N_GPIO_PIN;
    GPIO_InitStructure.GPIO_Alternate = TIMx_CH1N_GPIO_AF;
    GPIO_InitPeripheral(TIMx_CH1N_GPIO_PORT, &GPIO_InitStructure);   

    GPIO_InitStructure.Pin        = TIMx_CH2N_GPIO_PIN;
    GPIO_InitStructure.GPIO_Alternate = TIMx_CH2N_GPIO_AF;
    GPIO_InitPeripheral(TIMx_CH2N_GPIO_PORT, &GPIO_InitStructure);   
    
    GPIO_InitStructure.Pin        = TIMx_CH3N_GPIO_PIN;
    GPIO_InitStructure.GPIO_Alternate = TIMx_CH3N_GPIO_AF;
    GPIO_InitPeripheral(TIMx_CH3N_GPIO_PORT, &GPIO_InitStructure);   

}

/**
*\*\name    SysTick_Configuration.
*\*\fun     Configures the SysTick.
*\*\param   none
*\*\return  none 
**/
void SysTick_Configuration(void)
{
    /* Setup SysTick Timer for 10 msec interrupts ,(SystemCoreClock) / 100) cannot be greater than 0xFFFFFF */
    if (SysTick_Config((SystemCoreClock) / 100))
    {
        /* Capture error */
        while (1)
            ;
    }

    NVIC_SetPriority(SysTick_IRQn, 0x0);
}
